/*
 * Decompiled with CFR 0.152.
 */
package org.transforma.utilitarios;

import org.transforma.utilitarios.Punto;

public class Poligono {
    Punto[] puntos = new Punto[]{new Punto(-80.029232, 0.782712), new Punto(-79.671474, 0.9590465), new Punto(-78.736903, 1.150801), new Punto(-77.798907, 0.829368), new Punto(-76.888658, -0.625972), new Punto(-77.906026, -1.517418), new Punto(-78.953514, -4.048275), new Punto(-79.31551, -4.349104), new Punto(-80.254928, -4.363008), new Punto(-80.362538, -4.102276), new Punto(-80.892471, -2.32628), new Punto(-80.990122, -2.183993), new Punto(-80.832239, -1.02905)};

    public Poligono() throws IllegalArgumentException {
        if (this.puntos.length < 3) {
            throw new IllegalArgumentException("No es un pol\u00edgono");
        }
    }

    public void trasladar(int desX, int desY) {
        for (int indice = 0; indice < this.puntos.length; ++indice) {
            this.puntos[indice].setX(this.puntos[indice].getX() + (double)desX);
            this.puntos[indice].setY(this.puntos[indice].getY() + (double)desY);
        }
    }

    public void escalar(int escX, int escY) {
        for (int indice = 0; indice < this.puntos.length; ++indice) {
            this.puntos[indice].setX(this.puntos[indice].getX() * (double)escX);
            this.puntos[indice].setY(this.puntos[indice].getY() * (double)escY);
        }
    }

    public int numVertices() {
        return this.puntos.length;
    }

    public String toString() {
        String mensaje = "";
        for (int i = 0; i < this.puntos.length; ++i) {
            mensaje = mensaje + this.puntos[i].toString() + " ";
        }
        return mensaje;
    }

    public double perimetro() {
        double perimetro = 0.0;
        for (int i = 0; i < this.puntos.length; ++i) {
            perimetro += this.puntos[i].distancia(this.puntos[i + 1]);
        }
        return perimetro += this.puntos[this.puntos.length - 1].distancia(this.puntos[0]);
    }

    public boolean dentroPoligono(Punto p) {
        int i;
        int counter = 0;
        Punto p1 = new Punto(0.0, 0.0);
        Punto p2 = new Punto(0.0, 0.0);
        boolean retorno = false;
        int n = this.puntos.length;
        for (i = 0; i < n; ++i) {
            p1 = this.puntos[i];
            if (p.x != p1.x || p.y != p1.y) continue;
            retorno = true;
        }
        if (!retorno) {
            p1 = this.puntos[0];
            for (i = 1; i <= n; ++i) {
                double res = i % n;
                p2 = this.puntos[i % n];
                if (p.y > Math.min(p1.y, p2.y) && p.y <= Math.max(p1.y, p2.y) && p.x <= Math.max(p1.x, p2.x) && p1.y != p2.y) {
                    double xinters = (p.y - p1.y) * (p2.x - p1.x) / (p2.y - p1.y) + p1.x;
                    if (p1.x == p2.x || p.x <= xinters) {
                        ++counter;
                    }
                }
                p1 = p2;
            }
            retorno = counter % 2 != 0;
        }
        return retorno;
    }
}

