/*
 * Decompiled with CFR 0.152.
 */
package org.transforma.utilitarios;

import java.io.Serializable;
import java.math.BigDecimal;

public class ElipsoideGRS80
implements Serializable {
    private static final long serialVersionUID = 123L;
    public static final BigDecimal SEMIEJE_ECUATORIAL = new BigDecimal(6378137.0);
    private BigDecimal semiejePolar;
    private BigDecimal achatamiento;
    private BigDecimal excentricidadSecundariaAlCuadrado;
    private BigDecimal radioPolarCurvatura;
    private BigDecimal A0;
    private BigDecimal A1;
    private BigDecimal A2;
    private BigDecimal A4;
    private BigDecimal A6;
    private BigDecimal A8;

    public ElipsoideGRS80() {
        this.calculos();
    }

    private void calculos() {
        double potencia = SEMIEJE_ECUATORIAL.pow(2).doubleValue();
        this.radioPolarCurvatura = new BigDecimal(potencia / this.getSemiejePolar().doubleValue());
        double numerador = Math.pow(SEMIEJE_ECUATORIAL.doubleValue(), 2.0) - Math.pow(this.semiejePolar.doubleValue(), 2.0);
        double denominador = Math.pow(this.getSemiejePolar().doubleValue(), 2.0);
        this.excentricidadSecundariaAlCuadrado = new BigDecimal(numerador / denominador);
        double aux = 1.0 - 0.75 * this.excentricidadSecundariaAlCuadrado.doubleValue() * (1.0 - 0.9375 * this.excentricidadSecundariaAlCuadrado.doubleValue() * (1.0 - 0.9722222222222222 * this.excentricidadSecundariaAlCuadrado.doubleValue() * (1.0 - 0.984375 * this.excentricidadSecundariaAlCuadrado.doubleValue() * (1.0 - 0.99 * this.excentricidadSecundariaAlCuadrado.doubleValue()))));
        this.A0 = new BigDecimal(aux);
        aux = 0.75 * this.excentricidadSecundariaAlCuadrado.doubleValue() * (1.0 - 1.5625 * this.excentricidadSecundariaAlCuadrado.doubleValue() * (1.0 - 1.2833333333333334 * this.excentricidadSecundariaAlCuadrado.doubleValue() * (1.0 - 1.1889204545454546 * this.excentricidadSecundariaAlCuadrado.doubleValue() * (1.0 - 1.1413978494623656 * this.excentricidadSecundariaAlCuadrado.doubleValue()))));
        this.A1 = new BigDecimal(aux);
        aux = 0.625 * this.excentricidadSecundariaAlCuadrado.doubleValue() * (1.0 - 0.9652777777777778 * this.excentricidadSecundariaAlCuadrado.doubleValue() * (1.0 - 0.9775179856115108 * this.excentricidadSecundariaAlCuadrado.doubleValue() * (1.0 - 0.9840290555044465 * this.excentricidadSecundariaAlCuadrado.doubleValue())));
        this.A2 = new BigDecimal(aux);
        aux = 0.4861111111111111 * this.excentricidadSecundariaAlCuadrado.doubleValue() * this.excentricidadSecundariaAlCuadrado.doubleValue() * (1.0 - 1.953125 * this.excentricidadSecundariaAlCuadrado.doubleValue() * (1.0 - 1.4737933333333333 * this.excentricidadSecundariaAlCuadrado.doubleValue()));
        this.A4 = new BigDecimal(aux);
        aux = 0.41015625 * this.excentricidadSecundariaAlCuadrado.doubleValue() * this.excentricidadSecundariaAlCuadrado.doubleValue() * this.excentricidadSecundariaAlCuadrado.doubleValue() * (1.0 - 2.9475 * this.excentricidadSecundariaAlCuadrado.doubleValue());
        this.A6 = new BigDecimal(aux);
        aux = 0.3609375 * this.excentricidadSecundariaAlCuadrado.doubleValue() * this.excentricidadSecundariaAlCuadrado.doubleValue() * this.excentricidadSecundariaAlCuadrado.doubleValue() * this.excentricidadSecundariaAlCuadrado.doubleValue();
        this.A8 = new BigDecimal(aux);
    }

    public BigDecimal getSemiejePolar() {
        double sp = SEMIEJE_ECUATORIAL.doubleValue() * (1.0 - this.getAchatamiento().doubleValue());
        this.semiejePolar = new BigDecimal(sp);
        return this.semiejePolar;
    }

    public void setSemiejePolar(BigDecimal semiejePolar) {
        this.semiejePolar = semiejePolar;
    }

    public BigDecimal getAchatamiento() {
        double division = 0.003352810681182319;
        this.achatamiento = new BigDecimal(division);
        return this.achatamiento;
    }

    public void setAchatamiento(BigDecimal achatamiento) {
        this.achatamiento = achatamiento;
    }

    public BigDecimal getExcentricidadSecundariaAlCuadrado() {
        return this.excentricidadSecundariaAlCuadrado;
    }

    public void setExcentricidadSecundariaAlCuadrado(BigDecimal excentricidadSecundariaAlCuadrado) {
        this.excentricidadSecundariaAlCuadrado = excentricidadSecundariaAlCuadrado;
    }

    public BigDecimal getA0() {
        return this.A0;
    }

    public void setA0(BigDecimal A0) {
        this.A0 = A0;
    }

    public BigDecimal getA1() {
        return this.A1;
    }

    public void setA1(BigDecimal A1) {
        this.A1 = A1;
    }

    public BigDecimal getA2() {
        return this.A2;
    }

    public void setA2(BigDecimal A2) {
        this.A2 = A2;
    }

    public BigDecimal getA4() {
        return this.A4;
    }

    public void setA4(BigDecimal A4) {
        this.A4 = A4;
    }

    public BigDecimal getA6() {
        return this.A6;
    }

    public void setA6(BigDecimal A6) {
        this.A6 = A6;
    }

    public BigDecimal getA8() {
        return this.A8;
    }

    public void setA8(BigDecimal A8) {
        this.A8 = A8;
    }

    public BigDecimal getRadioPolarCurvatura() {
        return this.radioPolarCurvatura;
    }

    public void setRadioPolarCurvatura(BigDecimal radioPolarCurvatura) {
        this.radioPolarCurvatura = radioPolarCurvatura;
    }
}

