/*
 * Decompiled with CFR 0.152.
 */
package org.transforma.utilitarios;

import java.io.Serializable;
import org.transforma.utilitarios.ElipsoideGRS80;

public class BlachutUTMgeograficas
implements Serializable {
    private static final long serialVersionUID = 123L;
    static final double P_PRIMA = 206264.806247;
    static final double FACTOR_ESCALA = 0.9996;
    static final double EPSILON = 1.0E-4;
    private double excentricidadSecundariaAlCuadrado;
    private double radioPolarCurvatura;
    private double norte;
    private double este;
    private double fi1;
    private double b1;
    private double b2;
    private double b3;
    private double b4;
    private double b5;
    private double b6;
    private double x;
    private double y;
    private double pP;
    private double pN;
    private double v;
    private double meridianoCentral;
    private double A0;
    private double A1;
    private double A2;
    private double A4;
    private double A6;
    private double A8;
    private int zona;

    public BlachutUTMgeograficas(double norte, double este, int zona) {
        this.norte = norte;
        this.este = este;
        this.zona = zona;
        ElipsoideGRS80 pElipsoide = new ElipsoideGRS80();
        this.excentricidadSecundariaAlCuadrado = pElipsoide.getExcentricidadSecundariaAlCuadrado().doubleValue();
        this.radioPolarCurvatura = pElipsoide.getRadioPolarCurvatura().doubleValue();
        this.A0 = pElipsoide.getA0().doubleValue();
        this.A1 = pElipsoide.getA1().doubleValue();
        this.A2 = pElipsoide.getA2().doubleValue();
        this.A4 = pElipsoide.getA4().doubleValue();
        this.A6 = pElipsoide.getA6().doubleValue();
        this.A8 = pElipsoide.getA8().doubleValue();
        this.calculos();
    }

    public void calculos() {
        this.x = this.norte > 200000.0 ? (this.norte - 1.0E7) / 0.9996 : this.norte / 0.9996;
        this.y = (this.este - 500000.0) / 0.9996;
        double fisub1 = this.x / (this.A0 * this.radioPolarCurvatura);
        double auxB = this.B(fisub1);
        double diferencia = auxB - this.x;
        double i = Math.abs(diferencia);
        double j = 1.0E-4;
        while (i > j) {
            auxB = this.B(fisub1 += (this.x - auxB) / (this.A0 * this.radioPolarCurvatura));
            diferencia = auxB - this.x;
            i = Math.abs(diferencia);
        }
        this.fi1 = fisub1;
        double coseno = Math.cos(this.fi1);
        double potencia = Math.pow(coseno, 2.0);
        double multiplicacion = this.excentricidadSecundariaAlCuadrado * potencia;
        double adicion = 1.0 + multiplicacion;
        this.v = Math.sqrt(adicion);
        this.pN = this.radioPolarCurvatura / this.v;
        this.pP = this.pN * Math.cos(this.fi1);
        this.b1 = 1.0 / this.pP;
        double b = -0.5 * Math.pow(this.b1, 2.0) * Math.sin(this.fi1) * Math.cos(this.fi1);
        double suma = 1.0 + this.excentricidadSecundariaAlCuadrado * Math.pow(Math.cos(this.fi1), 2.0);
        this.b2 = b * suma;
        b = -0.16666666666666666 * Math.pow(this.b1, 3.0);
        double sum1 = 2.0 - Math.pow(Math.cos(this.fi1), 2.0);
        double sum2 = this.excentricidadSecundariaAlCuadrado * Math.pow(Math.cos(this.fi1), 4.0);
        this.b3 = b * (sum1 + sum2);
        b = -0.08333333333333333 * Math.pow(this.b1, 2.0) * this.b2;
        sum1 = (2.0 - 9.0 * this.excentricidadSecundariaAlCuadrado) * Math.pow(Math.cos(this.fi1), 2.0);
        sum2 = 10.0 * this.excentricidadSecundariaAlCuadrado * Math.pow(Math.cos(this.fi1), 4.0);
        double sum3 = 4.0 * Math.pow(this.excentricidadSecundariaAlCuadrado, 2.0) * Math.pow(Math.cos(this.fi1), 6.0);
        this.b4 = b * (3.0 + sum1 + sum2 - sum3);
        b = 0.008333333333333333 * Math.pow(this.b1, 5.0);
        sum1 = 24.0 - 20.0 * Math.pow(Math.cos(this.fi1), 2.0);
        sum2 = 1.0 + 8.0 * this.excentricidadSecundariaAlCuadrado * Math.pow(Math.cos(this.fi1), 4.0);
        sum3 = 2.0 * this.excentricidadSecundariaAlCuadrado * Math.pow(Math.cos(this.fi1), 6.0);
        this.b5 = b * (sum1 + sum2 - sum3);
        b = 0.002777777777777778 * Math.pow(this.b1, 4.0) * this.b2;
        sum1 = 45.0 + 16.0 * Math.pow(Math.cos(this.fi1), 4.0);
        this.b6 = b * sum1;
        double meridianoCen = 0.0;
        meridianoCen = this.zona == 17 ? Math.toRadians(-81.0) : Math.toRadians(-75.0);
        this.meridianoCentral = meridianoCen;
    }

    public double B(double angulo) {
        double coseno = Math.cos(angulo);
        double seno = Math.sin(angulo);
        double prod0 = this.A0 * this.radioPolarCurvatura * angulo;
        double prod1 = this.A1 * this.radioPolarCurvatura * seno * coseno;
        double prod2 = this.A2 * Math.pow(seno, 2.0);
        double prod3 = this.A4 * Math.pow(seno, 4.0);
        double prod4 = this.A6 * Math.pow(seno, 6.0);
        double prod5 = this.A8 * Math.pow(seno, 8.0);
        double b = prod0 - prod1 * (1.0 + prod2 + prod3 + prod4 + prod5);
        return b;
    }

    public double fiGeografica() {
        double fi = this.fi1 + this.b2 * Math.pow(this.y, 2.0) + this.b4 * Math.pow(this.y, 4.0) + this.b6 * Math.pow(this.y, 6.0);
        return fi;
    }

    public double lamdaGeografica() {
        double sum1 = this.b1 * this.y;
        double sum2 = this.b3 * Math.pow(this.y, 3.0);
        double sum5 = this.b5 * Math.pow(this.y, 5.0);
        double sumaTot = this.meridianoCentral + sum1 + sum2 + sum5;
        return sumaTot;
    }

    public double getB1() {
        return this.b1;
    }

    public void setB1(double b1) {
        this.b1 = b1;
    }

    public double getExcentricidadSecundariaAlCuadrado() {
        return this.excentricidadSecundariaAlCuadrado;
    }

    public void setExcentricidadSecundariaAlCuadrado(double excentricidadSecundariaAlCuadrado) {
        this.excentricidadSecundariaAlCuadrado = excentricidadSecundariaAlCuadrado;
    }

    public double getB2() {
        return this.b2;
    }

    public void setB2(double b2) {
        this.b2 = b2;
    }

    public double getB3() {
        return this.b3;
    }

    public void setB3(double b3) {
        this.b3 = b3;
    }

    public double getB4() {
        return this.b4;
    }

    public void setB4(double b4) {
        this.b4 = b4;
    }

    public double getpP() {
        return this.pP;
    }

    public void setpP(double pP) {
        this.pP = pP;
    }

    public double getpN() {
        return this.pN;
    }

    public void setpN(double pN) {
        this.pN = pN;
    }

    public double getMeridianoCentral() {
        return this.meridianoCentral;
    }

    public void setMeridianoCentral(double meridianoCentral) {
        this.meridianoCentral = meridianoCentral;
    }

    public double getV() {
        return this.v;
    }

    public void setV(double v) {
        this.v = v;
    }

    public double getB5() {
        return this.b5;
    }

    public void setB5(double b5) {
        this.b5 = b5;
    }

    public double getB6() {
        return this.b6;
    }

    public void setB6(double b6) {
        this.b6 = b6;
    }

    public int getZona() {
        return this.zona;
    }

    public void setZona(int zona) {
        this.zona = zona;
    }

    public double getNorte() {
        return this.norte;
    }

    public void setNorte(double norte) {
        this.norte = norte;
    }

    public double getEste() {
        return this.este;
    }

    public void setEste(double este) {
        this.este = este;
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getRadioPolarCurvatura() {
        return this.radioPolarCurvatura;
    }

    public void setRadioPolarCurvatura(double radioPolarCurvatura) {
        this.radioPolarCurvatura = radioPolarCurvatura;
    }

    public double getA0() {
        return this.A0;
    }

    public void setA0(double A0) {
        this.A0 = A0;
    }

    public double getA1() {
        return this.A1;
    }

    public void setA1(double A1) {
        this.A1 = A1;
    }

    public double getA2() {
        return this.A2;
    }

    public void setA2(double A2) {
        this.A2 = A2;
    }

    public double getA4() {
        return this.A4;
    }

    public void setA4(double A4) {
        this.A4 = A4;
    }

    public double getA6() {
        return this.A6;
    }

    public void setA6(double A6) {
        this.A6 = A6;
    }

    public double getA8() {
        return this.A8;
    }

    public void setA8(double A8) {
        this.A8 = A8;
    }

    public double getFi1() {
        return this.fi1;
    }

    public void setFi1(double fi1) {
        this.fi1 = fi1;
    }
}

