/*
 * Decompiled with CFR 0.152.
 */
package org.transforma.utilitarios;

import java.io.Serializable;
import org.transforma.utilitarios.ElipsoideGRS80;

public class BlachutGeograficaUTM
implements Serializable {
    private static final long serialVersionUID = 123L;
    private double excentricidadPrincipalAlCuadrado;
    private double excentricidadSecundariaAlCuadrado;
    private static final double FACTOR_ESCALA = 0.9996;
    private double radioPolarCurvatura;
    private double latitud;
    private double longitud;
    private double fi;
    private double lamda;
    private double A0;
    private double A1;
    private double A2;
    private double A4;
    private double A6;
    private double A8;
    private double V;
    private double M;
    private double N;
    private double R;
    private double P;
    private double aa1;
    private double aa2;
    private double aa3;
    private double aa4;
    private double aa5;
    private double aa6;
    private int meridianoCentral;
    private int meridianoCentral2;
    private int numeroZona;
    private int zona2;

    public BlachutGeograficaUTM(double latitud, double longitud) {
        this.latitud = latitud;
        this.longitud = longitud;
        this.fi = Math.toRadians(latitud);
        this.lamda = Math.toRadians(longitud);
        ElipsoideGRS80 pElipsoide = new ElipsoideGRS80();
        this.excentricidadSecundariaAlCuadrado = pElipsoide.getExcentricidadSecundariaAlCuadrado().doubleValue();
        this.radioPolarCurvatura = pElipsoide.getRadioPolarCurvatura().doubleValue();
        this.A0 = pElipsoide.getA0().doubleValue();
        this.A1 = pElipsoide.getA1().doubleValue();
        this.A2 = pElipsoide.getA2().doubleValue();
        this.A4 = pElipsoide.getA4().doubleValue();
        this.A6 = pElipsoide.getA6().doubleValue();
        this.A8 = pElipsoide.getA8().doubleValue();
        this.calculos();
    }

    private void calculos() {
        double coseno = Math.cos(this.fi);
        double potencia = Math.pow(coseno, 2.0);
        double multiplicacion = this.excentricidadSecundariaAlCuadrado * potencia;
        double adicion = 1.0 + multiplicacion;
        this.V = Math.sqrt(adicion);
        this.M = this.radioPolarCurvatura / Math.pow(this.V, 3.0);
        this.N = this.radioPolarCurvatura / this.V;
        this.R = Math.sqrt(this.M * this.N);
        this.P = this.N * Math.cos(this.fi);
        this.numeroZona = (int)(31.0 + this.longitud / 6.0);
        this.meridianoCentral = this.numeroZona * 6 - 183;
        this.aa2 = this.P / 2.0 * Math.sin(this.fi);
        double division = this.P / 6.0;
        double prod1 = 2.0 * Math.pow(Math.cos(this.fi), 2.0);
        double prod2 = this.excentricidadSecundariaAlCuadrado * Math.pow(Math.cos(this.fi), 4.0);
        double sumatTotal = -1.0 + prod1 + prod2;
        this.aa3 = division * sumatTotal;
        division = this.aa2 / 12.0;
        prod1 = 6.0 * Math.pow(Math.cos(this.fi), 2.0);
        prod2 = 9.0 * this.excentricidadSecundariaAlCuadrado * Math.pow(Math.cos(this.fi), 4.0);
        double prod3 = 4.0 * Math.pow(this.excentricidadSecundariaAlCuadrado, 4.0) * Math.pow(Math.cos(this.fi), 6.0);
        double sumaTotal = -1.0 + prod1 + prod2 + prod3;
        this.aa4 = division * sumaTotal;
        division = 0.008333333333333333 * this.P;
        prod1 = 1.0 - 20.0 * Math.pow(Math.cos(this.fi), 2.0);
        prod2 = (24.0 - 58.0 * this.excentricidadSecundariaAlCuadrado) * Math.pow(Math.cos(this.fi), 4.0);
        prod3 = 72.0 * this.excentricidadSecundariaAlCuadrado * Math.pow(Math.cos(this.fi), 6.0);
        this.aa5 = division * (prod1 + prod2 + prod3);
        division = 0.002777777777777778 * this.aa2;
        prod1 = 1.0 - 60.0 * Math.pow(Math.cos(this.fi), 2.0);
        prod2 = 120.0 * Math.pow(Math.cos(this.fi), 4.0);
        this.aa6 = division * (prod1 + prod2);
    }

    private double deltaLamda(int mc) {
        double dl = this.longitud - (double)mc;
        return Math.toRadians(dl);
    }

    public double B() {
        double coseno = Math.cos(this.fi);
        double seno = Math.sin(this.fi);
        double prod0 = this.A0 * this.radioPolarCurvatura * this.fi;
        double prod1 = this.A1 * this.radioPolarCurvatura * seno * coseno;
        double prod2 = this.A2 * Math.pow(seno, 2.0);
        double prod3 = this.A4 * Math.pow(seno, 4.0);
        double prod4 = this.A6 * Math.pow(seno, 6.0);
        double prod5 = this.A8 * Math.pow(seno, 8.0);
        double b = prod0 - prod1 * (1.0 + prod2 + prod3 + prod4 + prod5);
        return b;
    }

    public double xUTM2() {
        this.meridianoCentral2 = Math.abs(this.longitud) >= 77.5 && Math.abs(this.longitud) <= 78.5 ? (this.meridianoCentral == -75 ? -81 : -75) : this.meridianoCentral;
        double prod1 = this.aa2 * Math.pow(this.deltaLamda(this.meridianoCentral2), 2.0);
        double prod2 = this.aa4 * Math.pow(this.deltaLamda(this.meridianoCentral2), 4.0);
        double prod3 = this.aa6 * Math.pow(this.deltaLamda(this.meridianoCentral2), 6.0);
        double sumaTotal = this.B() + prod1 + prod2 + prod3;
        sumaTotal = this.latitud < 0.0 ? sumaTotal * 0.9996 + 1.0E7 : (sumaTotal *= 0.9996);
        this.zona2 = this.numeroZona2(this.meridianoCentral2);
        return sumaTotal;
    }

    public int numeroZona2(int meridianoCentral2) {
        if (meridianoCentral2 == -81) {
            return 17;
        }
        return 18;
    }

    public double xUTM() {
        double prod1 = this.aa2 * Math.pow(this.deltaLamda(this.meridianoCentral), 2.0);
        double prod2 = this.aa4 * Math.pow(this.deltaLamda(this.meridianoCentral), 4.0);
        double prod3 = this.aa6 * Math.pow(this.deltaLamda(this.meridianoCentral), 6.0);
        double sumaTotal = this.B() + prod1 + prod2 + prod3;
        sumaTotal = this.latitud < 0.0 ? sumaTotal * 0.9996 + 1.0E7 : (sumaTotal *= 0.9996);
        return sumaTotal;
    }

    public double yUTM2() {
        this.meridianoCentral2 = Math.abs(this.longitud) >= 77.5 && Math.abs(this.longitud) <= 78.5 ? (this.meridianoCentral == -75 ? -81 : -75) : this.meridianoCentral;
        double prod1 = this.P * this.deltaLamda(this.meridianoCentral2);
        double prod2 = this.aa3 * Math.pow(this.deltaLamda(this.meridianoCentral2), 3.0);
        double prod3 = this.aa5 * Math.pow(this.deltaLamda(this.meridianoCentral2), 5.0);
        double sumaTotal = prod1 + prod2 + prod3;
        sumaTotal = sumaTotal * 0.9996 + 500000.0;
        return sumaTotal;
    }

    public double yUTM() {
        double prod1 = this.P * this.deltaLamda(this.meridianoCentral);
        double prod2 = this.aa3 * Math.pow(this.deltaLamda(this.meridianoCentral), 3.0);
        double prod3 = this.aa5 * Math.pow(this.deltaLamda(this.meridianoCentral), 5.0);
        double sumaTotal = prod1 + prod2 + prod3;
        sumaTotal = sumaTotal * 0.9996 + 500000.0;
        return sumaTotal;
    }

    public int getNumeroZona() {
        return this.numeroZona;
    }

    public void setNumeroZona(int numeroZona) {
        this.numeroZona = numeroZona;
    }

    public int getMeridianoCentral() {
        return this.meridianoCentral;
    }

    public void setMeridianoCentral(int meridianoCentral) {
        this.meridianoCentral = meridianoCentral;
    }

    public int getMeridianoCentral2() {
        return this.meridianoCentral2;
    }

    public void setMeridianoCentral2(int meridianoCentral2) {
        this.meridianoCentral2 = meridianoCentral2;
    }

    public int getZona2() {
        return this.zona2;
    }

    public void setZona2(int zona2) {
        this.zona2 = zona2;
    }

    public double getLatitud() {
        return this.latitud;
    }

    public void setLatitud(double latitud) {
        this.latitud = latitud;
    }

    public double getLongitud() {
        return this.longitud;
    }

    public void setLongitud(double longitud) {
        this.longitud = longitud;
    }

    public double getFi() {
        return this.fi;
    }

    public void setFi(double fi) {
        this.fi = fi;
    }

    public double getLamda() {
        return this.lamda;
    }

    public void setLamda(double lamda) {
        this.lamda = lamda;
    }

    public double getExcentricidadPrincipalAlCuadrado() {
        return this.excentricidadPrincipalAlCuadrado;
    }

    public void setExcentricidadPrincipalAlCuadrado(double excentricidadPrincipalAlCuadrado) {
        this.excentricidadPrincipalAlCuadrado = excentricidadPrincipalAlCuadrado;
    }

    public double getExcentricidadSecundariaAlCuadrado() {
        return this.excentricidadSecundariaAlCuadrado;
    }

    public void setExcentricidadSecundariaAlCuadrado(double excentricidadSecundariaAlCuadrado) {
        this.excentricidadSecundariaAlCuadrado = excentricidadSecundariaAlCuadrado;
    }

    public double getA0() {
        return this.A0;
    }

    public void setA0(double A0) {
        this.A0 = A0;
    }

    public double getA1() {
        return this.A1;
    }

    public void setA1(double A1) {
        this.A1 = A1;
    }

    public double getA2() {
        return this.A2;
    }

    public void setA2(double A2) {
        this.A2 = A2;
    }

    public double getA4() {
        return this.A4;
    }

    public void setA4(double A4) {
        this.A4 = A4;
    }

    public double getA6() {
        return this.A6;
    }

    public void setA6(double A6) {
        this.A6 = A6;
    }

    public double getA8() {
        return this.A8;
    }

    public void setA8(double A8) {
        this.A8 = A8;
    }

    public double getV() {
        return this.V;
    }

    public void setV(double V) {
        this.V = V;
    }

    public double getM() {
        return this.M;
    }

    public void setM(double M) {
        this.M = M;
    }

    public double getN() {
        return this.N;
    }

    public void setN(double N) {
        this.N = N;
    }

    public double getR() {
        return this.R;
    }

    public void setR(double R) {
        this.R = R;
    }

    public double getP() {
        return this.P;
    }

    public void setP(double P) {
        this.P = P;
    }

    public double getAa1() {
        return this.aa1;
    }

    public void setAa1(double aa1) {
        this.aa1 = aa1;
    }

    public double getAa2() {
        return this.aa2;
    }

    public void setAa2(double aa2) {
        this.aa2 = aa2;
    }

    public double getAa3() {
        return this.aa3;
    }

    public void setAa3(double aa3) {
        this.aa3 = aa3;
    }

    public double getAa4() {
        return this.aa4;
    }

    public void setAa4(double aa4) {
        this.aa4 = aa4;
    }

    public double getAa5() {
        return this.aa5;
    }

    public void setAa5(double aa5) {
        this.aa5 = aa5;
    }

    public double getAa6() {
        return this.aa6;
    }

    public void setAa6(double aa6) {
        this.aa6 = aa6;
    }

    public double getRadioPolarCurvatura() {
        return this.radioPolarCurvatura;
    }

    public void setRadioPolarCurvatura(double radioPolarCurvatura) {
        this.radioPolarCurvatura = radioPolarCurvatura;
    }
}

