/*
 * Decompiled with CFR 0.152.
 */
package org.transforma.utilitarios;

import java.io.Serializable;
import org.transforma.utilitarios.ProductoMatrices;

public class AprendizajeRNA
implements Serializable {
    private static final long serialVersionUID = 123L;
    private double latitud;
    private double longitud;
    private double[][] pesosRBL;
    private double[][] pesosLL;
    private double[] biasLL;
    private double[] distanciasRBL;
    private double[] distanciaLL;
    private double[][] funcionRadialBasica;
    private double[][] funcionLineal;
    private static final int NUM_NEURONAS = 22;
    private static final int NUM_ENTRADAS = 2;
    private static final double DESV_EST_NORM_LAT = 1.45434832441105;
    private static final double DESV_EST_NORM_LON = 1.064416282530482;
    private static final double DESV_EST_DESNORM_LAT = 1.454362964070863;
    private static final double DESV_EST_DESNORM_LON = 1.064462745777041;
    private static final double MEDIA_NORM_LAT = -0.997939237654321;
    private static final double MEDIA_NORM_LON = -78.9955858526235;
    private static final double MEDIA_DESNORM_LAT = -1.0012516247978;
    private static final double MEDIA_DESNORM_LON = -78.9977516874672;
    private static final double BIAS_RBL = 0.061670711937607;
    private double latitudDes;
    private double longitudDes;

    public AprendizajeRNA(double latitud, double longitud) {
        this.latitud = (latitud - -0.997939237654321) / 1.45434832441105;
        this.longitud = (longitud - -78.9955858526235) / 1.064416282530482;
        this.pesosRBL = new double[22][2];
        this.pesosRBL[0][0] = -2.313798088789696;
        this.pesosRBL[0][1] = -1.183129535398562;
        this.pesosRBL[1][0] = 0.746021658329204;
        this.pesosRBL[1][1] = 1.885642547321489;
        this.pesosRBL[2][0] = 1.224363430983478;
        this.pesosRBL[2][1] = -0.971091749124155;
        this.pesosRBL[3][0] = -2.097390280529056;
        this.pesosRBL[3][1] = 0.039525411441778;
        this.pesosRBL[4][0] = 0.502525295158308;
        this.pesosRBL[4][1] = 0.45926480455052;
        this.pesosRBL[5][0] = 0.255762367752089;
        this.pesosRBL[5][1] = 1.97942115054325;
        this.pesosRBL[6][0] = 0.626709017762744;
        this.pesosRBL[6][1] = 2.236228231922202;
        this.pesosRBL[7][0] = -1.499412832208911;
        this.pesosRBL[7][1] = -0.028160434640375;
        this.pesosRBL[8][0] = 0.109256257014862;
        this.pesosRBL[8][1] = -1.044542961727578;
        this.pesosRBL[9][0] = 0.835166663492524;
        this.pesosRBL[9][1] = -0.464664571918819;
        this.pesosRBL[10][0] = 0.00282853978632;
        this.pesosRBL[10][1] = 1.087381918414995;
        this.pesosRBL[11][0] = -0.300107504064239;
        this.pesosRBL[11][1] = 0.426920551117869;
        this.pesosRBL[12][0] = 0.533818081313606;
        this.pesosRBL[12][1] = -0.083974959337099;
        this.pesosRBL[13][0] = 0.633648513807154;
        this.pesosRBL[13][1] = 0.740966725154611;
        this.pesosRBL[14][0] = 0.97196248773796;
        this.pesosRBL[14][1] = 0.846224128938536;
        this.pesosRBL[15][0] = 0.333156710939383;
        this.pesosRBL[15][1] = 0.746225136718535;
        this.pesosRBL[16][0] = 0.029550703026734;
        this.pesosRBL[16][1] = 0.464145439940136;
        this.pesosRBL[17][0] = -2.304238060509167;
        this.pesosRBL[17][1] = -0.300563309637911;
        this.pesosRBL[18][0] = -0.021391529144503;
        this.pesosRBL[18][1] = -1.725503096828519;
        this.pesosRBL[19][0] = 0.044443780468133;
        this.pesosRBL[19][1] = -1.572079413494342;
        this.pesosRBL[20][0] = -1.71824700402947;
        this.pesosRBL[20][1] = -0.595064785997783;
        this.pesosRBL[21][0] = 0.324967686175134;
        this.pesosRBL[21][1] = 0.328498270758968;
        this.pesosLL = new double[2][22];
        this.pesosLL[0][0] = 177987.6675302862;
        this.pesosLL[0][1] = -2049958.684136763;
        this.pesosLL[0][2] = 703694.5287927211;
        this.pesosLL[0][3] = -2907314.808393518;
        this.pesosLL[0][4] = 0.0;
        this.pesosLL[0][5] = -3759141.455435426;
        this.pesosLL[0][6] = 2671153.1887264;
        this.pesosLL[0][7] = 9567282.86247351;
        this.pesosLL[0][8] = 7426853.06018138;
        this.pesosLL[0][9] = 1404113.115917737;
        this.pesosLL[0][10] = 1.628200366366949E7;
        this.pesosLL[0][11] = -3.084794248095476E7;
        this.pesosLL[0][12] = -2.354921986604446E7;
        this.pesosLL[0][13] = -3.621992385024218E7;
        this.pesosLL[0][14] = 1.175936792122513E7;
        this.pesosLL[0][15] = 0.0;
        this.pesosLL[0][16] = -1682310.862998792;
        this.pesosLL[0][17] = 874558.2279260657;
        this.pesosLL[0][18] = 5659489.894610395;
        this.pesosLL[0][19] = -9840660.841582913;
        this.pesosLL[0][20] = -3126092.089047879;
        this.pesosLL[0][21] = 5.745605789467824E7;
        this.pesosLL[1][0] = -147450.7420336574;
        this.pesosLL[1][1] = 5531153.908998664;
        this.pesosLL[1][2] = -7442673.213955275;
        this.pesosLL[1][3] = 1569410.578902006;
        this.pesosLL[1][4] = 0.0;
        this.pesosLL[1][5] = 2394750.165436089;
        this.pesosLL[1][6] = -3376971.544540787;
        this.pesosLL[1][7] = -6291168.157408156;
        this.pesosLL[1][8] = 7173269.500898282;
        this.pesosLL[1][9] = 6.632986437536055E7;
        this.pesosLL[1][10] = 9525302.653326511;
        this.pesosLL[1][11] = 7.308219734018634E7;
        this.pesosLL[1][12] = -2.151393422866882E8;
        this.pesosLL[1][13] = -7.485564708227277E7;
        this.pesosLL[1][14] = 1.192439894200121E7;
        this.pesosLL[1][15] = 0.0;
        this.pesosLL[1][16] = -2.590447233401836E8;
        this.pesosLL[1][17] = -212995.2621047244;
        this.pesosLL[1][18] = -2364554.223272741;
        this.pesosLL[1][19] = 1135602.628278787;
        this.pesosLL[1][20] = 1626070.5543397;
        this.pesosLL[1][21] = 3.885838017150592E8;
        this.biasLL = new double[2];
        this.biasLL[0] = 1.09144898273021;
        this.biasLL[1] = -98.64584894529297;
        this.calculo();
    }

    private void calculo() {
        int i;
        this.distanciasRBL = new double[22];
        this.funcionRadialBasica = new double[22][1];
        for (i = 0; i < 22; ++i) {
            this.distanciasRBL[i] = this.distancia(this.latitud - this.pesosRBL[i][0], this.longitud - this.pesosRBL[i][1]);
        }
        for (i = 0; i < 22; ++i) {
            this.distanciasRBL[i] = this.distanciasRBL[i] * 0.061670711937607;
            double n = Math.pow(this.distanciasRBL[i], 2.0);
            this.funcionRadialBasica[i][0] = Math.pow(Math.E, -n);
        }
        ProductoMatrices pm = new ProductoMatrices(this.pesosLL, this.funcionRadialBasica);
        this.funcionLineal = pm.producto();
        this.latitud = this.funcionLineal[0][0] + this.biasLL[0];
        this.longitud = this.funcionLineal[1][0] + this.biasLL[1];
        this.latitudDes = this.latitud * 1.454362964070863 + -1.0012516247978;
        this.longitudDes = this.longitud * 1.064462745777041 + -78.9977516874672;
    }

    private double distancia(double a, double b) {
        double d = Math.sqrt(Math.pow(a, 2.0) + Math.pow(b, 2.0));
        return d;
    }

    public double[][] getPesosRBL() {
        return this.pesosRBL;
    }

    public void setPesosRBL(double[][] pesosRBL) {
        this.pesosRBL = pesosRBL;
    }

    public double[][] getPesosLL() {
        return this.pesosLL;
    }

    public void setPesosLL(double[][] pesosLL) {
        this.pesosLL = pesosLL;
    }

    public double[] getBiasLL() {
        return this.biasLL;
    }

    public void setBiasLL(double[] biasLL) {
        this.biasLL = biasLL;
    }

    public double[] getDistanciasRBL() {
        return this.distanciasRBL;
    }

    public void setDistanciasRBL(double[] distanciasRBL) {
        this.distanciasRBL = distanciasRBL;
    }

    public double[] getDistanciaLL() {
        return this.distanciaLL;
    }

    public void setDistanciaLL(double[] distanciaLL) {
        this.distanciaLL = distanciaLL;
    }

    public double[][] getFuncionRadialBasica() {
        return this.funcionRadialBasica;
    }

    public void setFuncionRadialBasica(double[][] funcionRadialBasica) {
        this.funcionRadialBasica = funcionRadialBasica;
    }

    public double[][] getFuncionLineal() {
        return this.funcionLineal;
    }

    public void setFuncionLineal(double[][] funcionLineal) {
        this.funcionLineal = funcionLineal;
    }

    public double getLatitudDes() {
        return this.latitudDes;
    }

    public void setLatitudDes(double latitudDes) {
        this.latitudDes = latitudDes;
    }

    public double getLongitudDes() {
        return this.longitudDes;
    }

    public void setLongitudDes(double longitudDes) {
        this.longitudDes = longitudDes;
    }

    public static double getDESV_EST_DESNORM_LAT() {
        return 1.454362964070863;
    }

    public static double getDESV_EST_DESNORM_LON() {
        return 1.064462745777041;
    }

    public static double getMEDIA_DESNORM_LAT() {
        return -1.0012516247978;
    }

    public static double getMEDIA_DESNORM_LON() {
        return -78.9977516874672;
    }

    public static double getBIAS_RBL() {
        return 0.061670711937607;
    }

    public double getLatitud() {
        return this.latitud;
    }

    public void setLatitud(double latitud) {
        this.latitud = latitud;
    }

    public double getLongitud() {
        return this.longitud;
    }

    public void setLongitud(double longitud) {
        this.longitud = longitud;
    }
}

