/*
 * Decompiled with CFR 0.152.
 */
package org.transforma.formularios;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.StringTokenizer;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.transforma.utilitarios.AprendizajeRNA;
import org.transforma.utilitarios.BlachutGeograficaUTM;
import org.transforma.utilitarios.Poligono;
import org.transforma.utilitarios.Punto;

public class IFConsultaArchivo
extends JInternalFrame {
    private File archivoEntrada;
    private File archivoSalida;
    private String lineaResultado;
    private String lineaResultado2;
    private static final String MSG_FUERA_POLIGONO = "Punto fuera del pol\u00edgono de cobertura";
    private static final String MSG_TSR = "Transformaci\u00f3n de Sistemas de Referencia";
    private JScrollPane jScrollPane1;
    private JTextArea jTextArea1;
    private JButton jbCargarArchivo;
    private JButton jbProcesar;
    private JLabel lbCarga;

    public IFConsultaArchivo() {
        this.initComponents();
        this.lbCarga.setText("");
        this.jbProcesar.setVisible(false);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.jbCargarArchivo = new JButton();
        this.lbCarga = new JLabel();
        this.jbProcesar = new JButton();
        this.setClosable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.setTitle("Transformar los puntos ingresados en un archivo tipo texto");
        this.setPreferredSize(new Dimension(900, 635));
        this.jScrollPane1.setVerticalScrollBarPolicy(21);
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setFont(new Font("Arial", 0, 12));
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setRows(20);
        this.jTextArea1.setText("\nOpci\u00f3n para transformar del Sistema de referencia  PSAD56 al Sistema SIRGAS Ecuador,  los puntos ingresados en un archivo de texto de extensi\u00f3n \n(.txt.).  Como resultado se obtiene un archivo de texto con los puntos transformados,  que  podr\u00e1 ser guardado en la ubicaci\u00f3n y con el nombre que \nrequiera  el usuario.\n\nEl archivo de entrada debe cumplir las siguientes caracter\u00edsticas:\n\n1. No debe tener encabezado.\n2. Los puntos deben ser expresados en grados decimales positivos, seguidos de las letras W, N, S seg\u00fan  el\n    hemisferio.\n3. El orden  ser\u00e1:  latitud  y luego longitud.\n4. La separaci\u00f3n entre columnas ser\u00e1 un espacio en blanco (no tabuladores).\n5. Para indicar los decimales se debe usar el punto (.).  No hay restricci\u00f3n en el  n\u00famero de decimales.\n6. No se realizar\u00e1 la transformaci\u00f3n  de los puntos que est\u00e9n fuera del pol\u00edgono de cobertura del Ecuador Continental.\n\nEjemplos de coordenadas:\n\n0.5n  77.22.0004w\n0.8561s 76.0054w\n0.9822N 77.6978w\n1.25556444s 78.6821W\n2.0057s 79.3654w");
        this.jTextArea1.setDisabledTextColor(Color.black);
        this.jScrollPane1.setViewportView(this.jTextArea1);
        this.jTextArea1.getAccessibleContext().setAccessibleName("");
        this.jbCargarArchivo.setIcon(new ImageIcon(this.getClass().getResource("/recursos/cargar.png")));
        this.jbCargarArchivo.setText("Cargar archivo");
        this.jbCargarArchivo.setToolTipText("Permite seleccionar el archivo a procesar");
        this.jbCargarArchivo.setName("jbCargarArchivo");
        this.jbCargarArchivo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IFConsultaArchivo.this.jbCargarArchivoActionPerformed(evt);
            }
        });
        this.lbCarga.setHorizontalAlignment(0);
        this.lbCarga.setText("jLabel1");
        this.lbCarga.setToolTipText("nombre del archivo a procesar");
        this.jbProcesar.setIcon(new ImageIcon(this.getClass().getResource("/recursos/transform.png")));
        this.jbProcesar.setText("Procesar Archivo");
        this.jbProcesar.setToolTipText("Realiza el proceso de transformaci\u00f3n a SIRGAS");
        this.jbProcesar.setName("jbCargarArchivo");
        this.jbProcesar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IFConsultaArchivo.this.jbProcesarActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(325, 325, 325).addComponent(this.jbProcesar)).addGroup(layout.createSequentialGroup().addGap(88, 88, 88).addComponent(this.lbCarga, -2, 665, -2))).addGap(0, 153, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(334, 334, 334).addComponent(this.jbCargarArchivo)).addGroup(layout.createSequentialGroup().addGap(26, 26, 26).addComponent(this.jScrollPane1, -2, 846, -2))).addContainerGap(26, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -2, 335, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jbCargarArchivo).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lbCarga, -2, 37, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jbProcesar).addContainerGap(110, Short.MAX_VALUE)));
        this.pack();
    }

    private void jbCargarArchivoActionPerformed(ActionEvent evt) {
        JFileChooser fcAbrir = new JFileChooser();
        fcAbrir.setFileFilter(new FileNameExtensionFilter("Archivo de texto", "txt"));
        int opcion = fcAbrir.showDialog(this, "Abrir");
        if (opcion == 0) {
            this.archivoEntrada = fcAbrir.getSelectedFile();
            this.lbCarga.setText(this.archivoEntrada.getAbsolutePath());
            this.jbProcesar.setVisible(true);
        }
    }

    private void jbProcesarActionPerformed(ActionEvent evt) {
        if (this.archivoEntrada == null) {
            JOptionPane.showMessageDialog(null, "no se ha seleccionado archivo para procesar", MSG_TSR, 0);
        } else if (this.esFormatoValido(this.archivoEntrada)) {
            JFileChooser fcGrabar = new JFileChooser();
            fcGrabar.showSaveDialog(this);
            this.archivoSalida = fcGrabar.getSelectedFile();
            if (this.archivoSalida == null) {
                JOptionPane.showMessageDialog(null, "no se ha generado ning\u00fan archivo", MSG_TSR, 0);
            } else {
                this.procesarArchivoPuntos(this.archivoEntrada);
                JOptionPane.showMessageDialog(null, "El archivo " + this.archivoSalida + ".txt se ha generado exitosamente", MSG_TSR, 1);
            }
        } else {
            JOptionPane.showMessageDialog(null, "El archivo " + this.archivoEntrada + " a procesar no tiene un formato v\u00e1lido", MSG_TSR, 0);
        }
    }

    public boolean esFormatoValido(File archivo) {
        boolean retorno = false;
        try {
            StringTokenizer st;
            FileReader fr = new FileReader(archivo);
            BufferedReader br = new BufferedReader(fr);
            String linea = br.readLine();
            if (linea != null && (st = new StringTokenizer(linea)).countTokens() == 2) {
                String s2 = st.nextToken();
                retorno = IFConsultaArchivo.esNumeroPositivo(s2.substring(0, s2.length() - 1));
            }
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(null, "El archivo " + this.archivoSalida + ".txt no tiene un formato v\u00e1lido", MSG_TSR, 1);
        }
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void procesarArchivoPuntos(File archivo) {
        String lat = "";
        String lon = "";
        int lineasLeidas = 0;
        double latitud = 0.0;
        double longitud = 0.0;
        String lineaResultado = "";
        int numTokens = 0;
        BufferedReader entrada = null;
        try {
            entrada = new BufferedReader(new FileReader(archivo));
            BufferedWriter bw = new BufferedWriter(new FileWriter(this.archivoSalida));
            while (entrada.ready()) {
                String linea = entrada.readLine();
                if (this.validaCoordenada(linea)) {
                    StringTokenizer st = new StringTokenizer(linea);
                    lat = "0.0";
                    lon = "0.0";
                    while (st.hasMoreTokens()) {
                        String s2 = st.nextToken();
                        if (++numTokens == 1) {
                            lat = s2;
                            continue;
                        }
                        lon = s2;
                        numTokens = 0;
                    }
                    ++lineasLeidas;
                    latitud = Double.parseDouble(lat.substring(0, lat.length() - 1));
                    longitud = Double.parseDouble(lon.substring(0, lon.length() - 1)) * -1.0;
                    if (lat.toUpperCase().endsWith("S")) {
                        latitud *= -1.0;
                    }
                    if (lineasLeidas == 1) {
                        lineaResultado = "PSAD56_Lat HLat PSAD56_Lon HLon SIRGAS_Lat HLatD SIRGAS_Long HLongD SIRGAS_Norte HN SIRGAS_Este HE SIRGAS_Zona";
                        bw.write(lineaResultado);
                        bw.newLine();
                        bw.flush();
                    }
                    latitud = (double)Math.round(latitud * Math.pow(10.0, 7.0)) / Math.pow(10.0, 7.0);
                    if (!this.dentroPoligonoDeCobertura(longitud = (double)Math.round(longitud * Math.pow(10.0, 7.0)) / Math.pow(10.0, 7.0), latitud)) {
                        String resultado = lat.substring(0, lat.length() - 1) + " ";
                        resultado = resultado + lat.substring(lat.length() - 1, lat.length()) + " ";
                        resultado = resultado + lon.substring(0, lon.length() - 1) + " ";
                        resultado = resultado + lon.substring(lon.length() - 1, lon.length()) + " ";
                        bw.write(resultado + MSG_FUERA_POLIGONO);
                        bw.newLine();
                        bw.flush();
                        continue;
                    }
                    lineaResultado = this.procesarPunto(latitud, longitud, lat, lon);
                    bw.write(lineaResultado);
                    bw.newLine();
                    bw.flush();
                    if (this.lineaResultado2.length() <= 0) continue;
                    bw.write(this.lineaResultado2);
                    bw.newLine();
                    bw.flush();
                    continue;
                }
                bw.write(linea + " Punto no corresponde a una coordenada v\u00e1lida: ");
                bw.newLine();
                bw.flush();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                entrada.close();
            }
            catch (IOException e1) {}
        }
    }

    public String procesarPunto(double latitud, double longitud, String lat, String lon) {
        String resultado = lat.substring(0, lat.length() - 1) + " ";
        resultado = resultado + lat.substring(lat.length() - 1, lat.length()) + " ";
        resultado = resultado + lon.substring(0, lon.length() - 1) + " ";
        resultado = resultado + lon.substring(lon.length() - 1, lon.length()) + " ";
        AprendizajeRNA frb = new AprendizajeRNA(latitud, longitud);
        latitud = frb.getLatitudDes();
        longitud = frb.getLongitudDes();
        String tipoLat = "N";
        BlachutGeograficaUTM gUTM = new BlachutGeograficaUTM(latitud, longitud);
        if (latitud < 0.0) {
            latitud *= -1.0;
            tipoLat = "S";
        }
        DecimalFormat df = new DecimalFormat("0.0000");
        resultado = resultado + String.valueOf(latitud) + " " + tipoLat + " " + String.valueOf(longitud *= -1.0) + " W";
        resultado = resultado + " " + String.valueOf(gUTM.xUTM()) + " N ";
        resultado = resultado + String.valueOf(gUTM.yUTM()) + " E ";
        resultado = resultado + String.valueOf(gUTM.getNumeroZona()) + " ";
        this.lineaResultado2 = "";
        if (Math.abs(longitud) >= 77.5 && Math.abs(longitud) <= 78.5) {
            for (int x = 0; x < 8; ++x) {
                this.lineaResultado2 = this.lineaResultado2 + " ";
            }
            this.lineaResultado2 = this.lineaResultado2 + String.valueOf(gUTM.xUTM2()) + " N ";
            this.lineaResultado2 = this.lineaResultado2 + String.valueOf(gUTM.yUTM2()) + " E ";
            this.lineaResultado2 = this.lineaResultado2 + String.valueOf(gUTM.getZona2());
        }
        return resultado;
    }

    public boolean validaCoordenada(String linea) {
        StringTokenizer st = new StringTokenizer(linea);
        String s2 = "";
        boolean retorno = false;
        if (st.countTokens() == 2) {
            s2 = st.nextToken();
            retorno = IFConsultaArchivo.esNumeroPositivo(s2.substring(0, s2.length() - 1));
        }
        return retorno;
    }

    public static boolean esNumeroPositivo(String cadena) {
        if (cadena == null || cadena.isEmpty()) {
            return false;
        }
        if (cadena.charAt(0) == '-') {
            return false;
        }
        for (int i = 0; i < cadena.length(); ++i) {
            if (Character.isDigit(cadena.charAt(i)) || cadena.charAt(i) == '.') continue;
            return false;
        }
        return true;
    }

    public boolean dentroPoligonoDeCobertura(double longitud, double latitud) {
        Poligono poligono = new Poligono();
        boolean dentro = poligono.dentroPoligono(new Punto(longitud, latitud));
        return dentro;
    }

    public String getLineaResultado() {
        return this.lineaResultado;
    }

    public void setLineaResultado(String lineaResultado) {
        this.lineaResultado = lineaResultado;
    }

    public String getLineaResultado2() {
        return this.lineaResultado2;
    }

    public void setLineaResultado2(String lineaResultado2) {
        this.lineaResultado2 = lineaResultado2;
    }

    public static String getMSG_TSR() {
        return MSG_TSR;
    }
}

